//OS version = ubuntu 16.04 LTS
//Scilab version 5.5.2

clear;
clc;

theta=0:0.001:2*%pi;                   		 //theta varies from 0 ˚ to 360˚

lambda=1;                      			// defining λ

d1=lambda/4;                  			//distance between the dipoles d1= λ/4

u1=(%pi*d1/lambda).*cos(theta);        		//u1 = πd1/λ*cosӨ

AF1=126.*cos(u1)+84.*cos(3*u1)+36.*cos(5*u1)+9.*cos(7*u1)+cos(9*u1); //expression for                                                                             //array factor N=10, N=2M, AF=∑an cos(2n-1)u	 for n=1 to M                                             
p=get("hdl");             		//get handle on current entity (here the polyline entity)

p.line_style=1;

polarplot(theta,AF1)		//polar plot of AF 

d2=lambda/2				//distance between the dipoles d2= λ/2

u2=(%pi*d2/lambda).*cos(theta);        		//u2 = πd2/λ*cosӨ

AF2=126.*cos(u2)+84.*cos(3*u2)+36.*cos(5*u2)+9.*cos(7*u2)+cos(9*u2);      //expression for 
							                     //array factor	

p.line_style=8;

polarplot(theta,AF2)			//polar plot of AF 


d3=3*lambda/4			//distance between the dipoles d3= 3λ/4

u3=(%pi*d3/lambda).*cos(theta);       			 //u3 = πd3/λ*cosӨ 

AF3=126.*cos(u3)+84.*cos(3*u3)+36.*cos(5*u3)+9.*cos(7*u3)+cos(9*u3);    //expression for 
							                   //array factor	

p.line_style=2;
 	
polarplot(theta,AF3)                                                            	//polar plot of AF 

d4=lambda		                 		//distance between the dipoles d4= λ

u4=(%pi*d4/lambda).*cos(theta);        			//u4 = πd4/λ*cosӨ

AF4=126.*cos(u4)+84.*cos(3*u4)+36.*cos(5*u4)+9.*cos(7*u4)+cos(9*u4);       //expression for 
								       //array factor

p.line_style=6;

polarplot(theta,AF4) 				//polar plot of AF 

title('POLAR PLOT OF ARRAY FACTOR PATTERN OF N ELEMENT BINOMIAL ARRAY CASE: N=10 and d = λ /4 , λ /2 , 3λ /4 , λ');

hl=legend('d = λ /4';'d = λ /2';'d = 3λ /4'; 'd = λ');

